/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command.argument;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ5\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\"\b\b\u0000\u0010\n*\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/command/argument/PartySlotArgumentType;", "Lcom/mojang/brigadier/arguments/ArgumentType;", "", "<init>", "()V", "Lcom/mojang/brigadier/StringReader;", "reader", "parse", "(Lcom/mojang/brigadier/StringReader;)Ljava/lang/Integer;", "", "S", "Lcom/mojang/brigadier/context/CommandContext;", "context", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "builder", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "listSuggestions", "(Lcom/mojang/brigadier/context/CommandContext;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;", "", "", "getExamples", "()Ljava/util/List;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nPartySlotArgumentType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartySlotArgumentType.kt\ncom/cobblemon/mod/common/command/argument/PartySlotArgumentType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1563#2:68\n1634#2,3:69\n*S KotlinDebug\n*F\n+ 1 PartySlotArgumentType.kt\ncom/cobblemon/mod/common/command/argument/PartySlotArgumentType\n*L\n47#1:68\n47#1:69,3\n*E\n"})
public final class PartySlotArgumentType
implements ArgumentType<Integer> {
    @NotNull
    public static final Companion Companion;
    private static final int MIN = 1;
    private static final int MAX = 6;
    @NotNull
    private static final List<String> EXAMPLES;
    @NotNull
    private static final DynamicCommandExceptionType INVALID_SLOT;

    @NotNull
    public Integer parse(@NotNull StringReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        int slot = reader.readInt();
        if (slot < 1) {
            CommandSyntaxException commandSyntaxException = CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooLow().createWithContext((ImmutableStringReader)reader, (Object)slot, (Object)1);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"createWithContext(...)");
            throw (Throwable)commandSyntaxException;
        }
        if (slot > 6) {
            CommandSyntaxException commandSyntaxException = CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().createWithContext((ImmutableStringReader)reader, (Object)slot, (Object)6);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"createWithContext(...)");
            throw (Throwable)commandSyntaxException;
        }
        return slot;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        CompletableFuture completableFuture = class_2172.method_9265((Iterable)EXAMPLES, (SuggestionsBuilder)builder);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"suggest(...)");
        return completableFuture;
    }

    @NotNull
    public List<String> getExamples() {
        return EXAMPLES;
    }

    private static final Message INVALID_SLOT$lambda$0(Object slot) {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)slot);
        objectArray[0] = slot;
        class_5250 class_52502 = LocalizationUtilsKt.commandLang("general.invalid-party-slot", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"commandLang(...)");
        return (Message)TextKt.red(class_52502);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = (Iterable)new IntRange(1, 6);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf((int)it));
        }
        EXAMPLES = (List)var3_3;
        INVALID_SLOT = new DynamicCommandExceptionType(PartySlotArgumentType::INVALID_SLOT$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J)\u0010\r\u001a\u00020\f\"\u0004\b\u0000\u0010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ1\u0010\u0011\u001a\u00020\f\"\u0004\b\u0000\u0010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/cobblemon/mod/common/command/argument/PartySlotArgumentType$Companion;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/command/argument/PartySlotArgumentType;", "partySlot", "()Lcom/cobblemon/mod/common/command/argument/PartySlotArgumentType;", "S", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "name", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lnet/minecraft/class_3222;", "player", "getPokemonOf", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/pokemon/Pokemon;", "", "MIN", "I", "MAX", "", "EXAMPLES", "Ljava/util/List;", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "INVALID_SLOT", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PartySlotArgumentType partySlot() {
            return new PartySlotArgumentType();
        }

        @NotNull
        public final <S> Pokemon getPokemon(@NotNull CommandContext<S> context, @NotNull String name) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Integer slot = (Integer)context.getArgument(name, Integer.TYPE);
            Object object = context.getSource();
            class_2168 class_21682 = object instanceof class_2168 ? (class_2168)object : null;
            if (class_21682 == null) {
                CommandSyntaxException commandSyntaxException = class_2168.field_9824.create();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
            class_2168 source = class_21682;
            class_1297 class_12972 = source.method_9228();
            class_3222 class_32222 = class_12972 instanceof class_3222 ? (class_3222)class_12972 : null;
            if (class_32222 == null) {
                CommandSyntaxException commandSyntaxException = class_2168.field_9824.create();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
            class_3222 player = class_32222;
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Pokemon pokemon = party.get(slot - 1);
            if (pokemon == null) {
                CommandSyntaxException commandSyntaxException = INVALID_SLOT.create((Object)slot);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
            return pokemon;
        }

        @NotNull
        public final <S> Pokemon getPokemonOf(@NotNull CommandContext<S> context, @NotNull String name, @NotNull class_3222 player) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Integer slot = (Integer)context.getArgument(name, Integer.TYPE);
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            Pokemon pokemon = party.get(slot - 1);
            if (pokemon == null) {
                CommandSyntaxException commandSyntaxException = INVALID_SLOT.create((Object)slot);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)commandSyntaxException), (String)"create(...)");
                throw (Throwable)commandSyntaxException;
            }
            return pokemon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

